package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * style - This attribute defines the styling language as a MIME type (charset should not be specified). This attribute is optional and defaults to <code>text/css</code> if it's missing.
 * object - The <a href="/en-US/docs/Glossary/Content_type">content type</a> of the resource specified by <strong>data</strong>. At least one of <strong>data</strong> and <strong>type</strong> must be defined.
 * li - This character attribute indicates the numbering type: <ul>  <li><code>a</code>: lowercase letters</li>  <li><code>A</code>: uppercase letters</li>  <li><code>i</code>: lowercase Roman numerals</li>  <li><code>I</code>: uppercase Roman numerals</li>  <li><code>1</code>: numbers</li> </ul> This type overrides the one used by its parent <a title="The HTML <ol> element represents an ordered list of items, typically rendered as a numbered list." href="/en-US/docs/Web/HTML/Element/ol"><code>&lt;ol&gt;</code></a> element, if any. <div class="note"> <strong>Usage note:</strong> This attribute has been deprecated: use the CSS  <a title="The list-style-type CSS property specifies the appearance of a list item element." href="/en-US/docs/Web/CSS/list-style-type"><code>list-style-type</code></a> property instead.</div>
 * param - Only used if the <code>valuetype</code> is set to "ref". Specifies the MIME type of values found at the URI specified by value.
 * source - The MIME-type of the resource, optionally with a <code>codecs</code> parameter. See <a class="external" href="https://tools.ietf.org/html/rfc4281">RFC 4281</a> for information about how to specify codecs.
 * button - The type of the button. Possible values are: <ul>  <li><code>submit</code>: The button submits the form data to the server. This is the default if the attribute is not specified, or if the attribute is dynamically changed to an empty or invalid value.</li>  <li><code>reset</code>: The button resets all the controls to their initial values.</li>  <li><code>button</code>: The button has no default behavior. It can have client-side scripts associated with the element's events, which are triggered when the events occur.</li> </ul>
 * script - <p>Indicates the type of script represented. The value of this attribute will be in one of the following categories:</p> <ul>  <li><strong>Omitted or a JavaScript MIME type:</strong> For HTML5-compliant browsers this indicates the script is JavaScript. HTML5 spec urges authors to omit the attribute rather than provided a redundant MIME type. In earlier browsers, this identified the scripting language of the embedded or imported (via the <code>src</code> attribute) code. JavaScript MIME types are <a href="/en-US/docs/Web/HTTP/Basics_of_HTTP/MIME_types">listed in the specification</a>.</li>  <li><strong><code>module</code>:</strong> <span class="inlineIndicator htmlVer htmlVerInline"><a href="/en-US/docs/HTML/HTML5">HTML5</a></span> For HTML5-compliant browsers&nbsp;the code is treated as a JavaScript module. Processing of the script contents are not affected by the <code>charset</code> and <code>defer</code> attributes. For information on using <code>module</code>, see <a class="external-icon external" href="https://hacks.mozilla.org/2015/08/es6-in-depth-modules/">ES6 in Depth: Modules</a>.&nbsp;<span title="This is an experimental API that should not be used in production code."><i class="icon-beaker"> </i></span></li>  <li><strong>Any other value or MIME type:</strong> Embedded content is treated as a data block which won't be processed by the browser. The <code>src</code> attribute will be ignored.</li> </ul> <p>Note that in Firefox you can use advanced features such as let statements and other features in later JS versions, by using <code>type=application/javascript;version=1.8</code>&nbsp;<span title="This API has not been standardized."><i class="icon-warning-sign"> </i></span>.&nbsp;Beware, however, that&nbsp;as this is a non-standard feature, this will most likely break support for&nbsp;other browsers, in particular Chromium-based browsers.</p> <p>For how to include <em>exotic programming languages</em>, read about <a href="/en-US/Add-ons/Code_snippets/Rosetta">Rosetta</a>.</p>
 * link - This attribute is used to define the type of the content linked to. The value of the attribute should be a MIME type such as <strong>text/html</strong>, <strong>text/css</strong>, and so on. The common use of this attribute is to define the type of style sheet linked and the most common current value is <strong>text/css</strong>, which indicates a Cascading Style Sheet format. It is also used on <code>rel="preload"</code> link types, to make sure the browser only downloads file types that it supports.
 * embed - The MIME&nbsp;type to use to select the plug-in to instantiate.
 * ul - Used to set the bullet style for the list. The values defined under <a class="new" href="/en-US/docs/HTML3.2">HTML3.2</a> and the transitional version of <a class="new" href="/en-US/docs/HTML4.01">HTML 4.0/4.01</a> are: <ul>  <li><code>circle</code>,</li>  <li><code>disc</code>,</li>  <li>and <code>square</code>.</li> </ul> <p>A fourth bullet type has been defined in the WebTV interface, but not all browsers support it: <code>triangle.</code></p> <p>If not present and if no <a href="/en-US/docs/CSS">CSS</a> <a title="The list-style-type CSS property specifies the appearance of a list item element." href="/en-US/docs/Web/CSS/list-style-type"><code>list-style-type</code></a> property does apply to the element, the user agent decide to use a kind of bullets depending on the nesting level of the list.</p> <div class="note"> <strong>Usage note:</strong> Do not use this attribute, as it has been deprecated; use the  <a href="/en-US/docs/CSS">CSS</a>  <a title="The list-style-type CSS property specifies the appearance of a list item element." href="/en-US/docs/Web/CSS/list-style-type"><code>list-style-type</code></a> property instead.</div>
 * a - Specifies the media type in the form of a <a title="MIME type: A&nbsp;MIME type&nbsp;(now properly called &quot;media type&quot;, but&nbsp;also sometimes &quot;content type&quot;) is a string sent along&nbsp;with a file indicating the file&nbsp;type (for example, a sound file might be labeled&nbsp;audio/ogg, or an image file&nbsp;image/png). It serves the same purpose as filename&nbsp;extensions traditionally do on Windows." class="glossaryLink" href="/en-US/docs/Glossary/MIME_type">MIME type</a> for the linked URL. It is purely advisory, with no built-in functionality.
 * input - The type of control to render. See <a href="#Form_<input>_types">Form &lt;input&gt; types</a> for the individual types, with links to more information about each.
 * area - This attribute specifies the media type in the form of a MIME type for the link target. Generally, this is provided strictly as advisory information; however, in the future a browser might add a small icon for multimedia types. For example, a browser might add a small speaker icon when type is set to audio/wav. For a complete list of recognized MIME types, see <a title="Linkification: https://www.w3.org/TR/html4/references.html#ref-MIMETYPES" class="external linkification-ext" href="https://www.w3.org/TR/html4/references.html#ref-MIMETYPES">https://www.w3.org/TR/html4/references.html#ref-MIMETYPES</a>. Use this attribute only if the <strong>href</strong> attribute is present.
 * ol - Indicates the numbering type: <ul>  <li><code>'a'</code> indicates lowercase letters,</li>  <li><code>'A'</code> indicates uppercase letters,</li>  <li><code>'i'</code> indicates lowercase Roman numerals,</li>  <li><code>'I'</code> indicates uppercase Roman numerals,</li>  <li>and <code>'1'</code> indicates numbers (default).</li> </ul> <p>The type set is used for the entire list unless a different <code><a href="/en-US/docs/Web/HTML/Element/li#attr-type">type</a></code> attribute is used within an enclosed <a title="The HTML <li> element is used to represent an item in a list. It must be contained in a parent element: an ordered list (<ol>), an unordered list (<ul>), or a menu (<menu>). In menus and unordered lists, list items are usually displayed using bullet points. In ordered lists, they are usually displayed with an ascending counter on the left, such as a number or letter." href="/en-US/docs/Web/HTML/Element/li"><code>&lt;li&gt;</code></a> element.</p> <div class="note"> <strong>Note:&nbsp;</strong>This attribute was deprecated in HTML4, but reintroduced in HTML5. Unless the value of the list number matters (e.g. in legal or technical documents where items are to be referenced by their number/letter), the CSS  <a title="The list-style-type CSS property specifies the appearance of a list item element." href="/en-US/docs/Web/CSS/list-style-type"><code>list-style-type</code></a> property should be used instead.</div>
 * menu - This attribute indicates the kind of menu being declared, and can be one of two values. <ul>  <li><code>context</code>: Indicates the <em>popup menu</em> state, which represents a group of commands activated through another element. This might be as a button menu referenced by a <code><a href="/en-US/docs/Web/HTML/Element/button#attr-menu">menu</a></code> attribute of a <a title="The HTML <button> element represents a clickable button." href="/en-US/docs/Web/HTML/Element/button"><code>&lt;button&gt;</code></a> element, or as context menu for an element with a <a href="/en-US/docs/HTML/Global_attributes#attr-contextmenu"><code>contextmenu</code></a> attribute. This value is the default if the attribute is missing and the parent element is also a <code>&lt;menu&gt;</code> element.</li>  <li><code>toolbar</code>: Indicates the <em>toolbar</em> state, which represents a toolbar consisting of a series of commands for user interaction. This might be in the form of an unordered list of <a title="The HTML <li> element is used to represent an item in a list. It must be contained in a parent element: an ordered list (<ol>), an unordered list (<ul>), or a menu (<menu>). In menus and unordered lists, list items are usually displayed using bullet points. In ordered lists, they are usually displayed with an ascending counter on the left, such as a number or letter." href="/en-US/docs/Web/HTML/Element/li"><code>&lt;li&gt;</code></a> elements, or, if the element has no <code>&lt;li&gt;</code> element children, flow content describing available commands. This value is the default if the attribute is missing.</li> </ul>
 * menuitem - This attribute indicates the kind of command, and can be one of three values. <ul>  <li><code>command</code>: A regular command with an associated action. This is the missing value default.</li>  <li><code>checkbox</code>: Represents a command that can be toggled between two different states.</li>  <li><code>radio</code>: Represent one selection from a group of commands that can be toggled as radio buttons.</li> </ul>
 */
object `type` extends Attr {
implicit object tag extends TagElement {
  type RefType = Nothing
}

@inline def :=(v: String) = new AttrPair[_type_attr.type]("type", v)
@inline def :=(v: Option[String]) = new OptionalAttrPair[_type_attr.type]("type", v)
type attrType = _type_attr.type

}

object _type_attr {
@inline implicit def toaApplied(pair: AttrPair[_type_attr.type]) = pair.asInstanceOf[AttrPair[a.tag.type]]
@inline implicit def toaOptionalApplied(pair: OptionalAttrPair[_type_attr.type]) = pair.asInstanceOf[OptionalAttrPair[a.tag.type]]
             
@inline implicit def toareaApplied(pair: AttrPair[_type_attr.type]) = pair.asInstanceOf[AttrPair[area.tag.type]]
@inline implicit def toareaOptionalApplied(pair: OptionalAttrPair[_type_attr.type]) = pair.asInstanceOf[OptionalAttrPair[area.tag.type]]
             
@inline implicit def tobuttonApplied(pair: AttrPair[_type_attr.type]) = pair.asInstanceOf[AttrPair[button.tag.type]]
@inline implicit def tobuttonOptionalApplied(pair: OptionalAttrPair[_type_attr.type]) = pair.asInstanceOf[OptionalAttrPair[button.tag.type]]
             
@inline implicit def toembedApplied(pair: AttrPair[_type_attr.type]) = pair.asInstanceOf[AttrPair[embed.tag.type]]
@inline implicit def toembedOptionalApplied(pair: OptionalAttrPair[_type_attr.type]) = pair.asInstanceOf[OptionalAttrPair[embed.tag.type]]
             
@inline implicit def toinputApplied(pair: AttrPair[_type_attr.type]) = pair.asInstanceOf[AttrPair[input.tag.type]]
@inline implicit def toinputOptionalApplied(pair: OptionalAttrPair[_type_attr.type]) = pair.asInstanceOf[OptionalAttrPair[input.tag.type]]
             
@inline implicit def toliApplied(pair: AttrPair[_type_attr.type]) = pair.asInstanceOf[AttrPair[li.tag.type]]
@inline implicit def toliOptionalApplied(pair: OptionalAttrPair[_type_attr.type]) = pair.asInstanceOf[OptionalAttrPair[li.tag.type]]
             
@inline implicit def tolinkApplied(pair: AttrPair[_type_attr.type]) = pair.asInstanceOf[AttrPair[link.tag.type]]
@inline implicit def tolinkOptionalApplied(pair: OptionalAttrPair[_type_attr.type]) = pair.asInstanceOf[OptionalAttrPair[link.tag.type]]
             
@inline implicit def tomenuApplied(pair: AttrPair[_type_attr.type]) = pair.asInstanceOf[AttrPair[menu.tag.type]]
@inline implicit def tomenuOptionalApplied(pair: OptionalAttrPair[_type_attr.type]) = pair.asInstanceOf[OptionalAttrPair[menu.tag.type]]
             
@inline implicit def tomenuitemApplied(pair: AttrPair[_type_attr.type]) = pair.asInstanceOf[AttrPair[menuitem.tag.type]]
@inline implicit def tomenuitemOptionalApplied(pair: OptionalAttrPair[_type_attr.type]) = pair.asInstanceOf[OptionalAttrPair[menuitem.tag.type]]
             
@inline implicit def toobjectApplied(pair: AttrPair[_type_attr.type]) = pair.asInstanceOf[AttrPair[`object`.tag.type]]
@inline implicit def toobjectOptionalApplied(pair: OptionalAttrPair[_type_attr.type]) = pair.asInstanceOf[OptionalAttrPair[`object`.tag.type]]
             
@inline implicit def toolApplied(pair: AttrPair[_type_attr.type]) = pair.asInstanceOf[AttrPair[ol.tag.type]]
@inline implicit def toolOptionalApplied(pair: OptionalAttrPair[_type_attr.type]) = pair.asInstanceOf[OptionalAttrPair[ol.tag.type]]
             
@inline implicit def toparamApplied(pair: AttrPair[_type_attr.type]) = pair.asInstanceOf[AttrPair[param.tag.type]]
@inline implicit def toparamOptionalApplied(pair: OptionalAttrPair[_type_attr.type]) = pair.asInstanceOf[OptionalAttrPair[param.tag.type]]
             
@inline implicit def toscriptApplied(pair: AttrPair[_type_attr.type]) = pair.asInstanceOf[AttrPair[script.tag.type]]
@inline implicit def toscriptOptionalApplied(pair: OptionalAttrPair[_type_attr.type]) = pair.asInstanceOf[OptionalAttrPair[script.tag.type]]
             
@inline implicit def tosourceApplied(pair: AttrPair[_type_attr.type]) = pair.asInstanceOf[AttrPair[source.tag.type]]
@inline implicit def tosourceOptionalApplied(pair: OptionalAttrPair[_type_attr.type]) = pair.asInstanceOf[OptionalAttrPair[source.tag.type]]
             
@inline implicit def tostyleApplied(pair: AttrPair[_type_attr.type]) = pair.asInstanceOf[AttrPair[style.tag.type]]
@inline implicit def tostyleOptionalApplied(pair: OptionalAttrPair[_type_attr.type]) = pair.asInstanceOf[OptionalAttrPair[style.tag.type]]
             
@inline implicit def toulApplied(pair: AttrPair[_type_attr.type]) = pair.asInstanceOf[AttrPair[ul.tag.type]]
@inline implicit def toulOptionalApplied(pair: OptionalAttrPair[_type_attr.type]) = pair.asInstanceOf[OptionalAttrPair[ul.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_type_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_type_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
